/*===================================================================================

  copyright: (C) Copyright 2003-2010 FileMaker, Inc. All Rights Reserved
  
  =================================================================================*/

function isStatusFrameValid()
{
	var valid = false;
	if (top.iwp != null && top.iwp.bodyFrame != null && top.iwp.bodyFrame.iwpinfo != null 
		&& top.iwp.statusFrame != null && top.iwp.statusFrame.document != null)
		valid = true;
	
	return valid;
} 

function isWindows()
{
	var result = false;
	var targ = "Windows";
	var av = navigator.userAgent;
	var start = av.indexOf(targ);
	if( start > -1 )
	{
		result = true;
	}
	return result;
}
	
function isSafari()
{
	var result = false;
	var targ = "AppleWebKit";
	var av = navigator.userAgent;
	var start = av.indexOf(targ);
	if( start > -1 )
	{
		result = true;
	}
	return result;
}
		
function isSafari4Plus()
{
	var result = false;
	var safariStr = "AppleWebKit";
	var verStartStr = "Version/";
	var verEndStr = ".";
	var appVerStr = navigator.appVersion;
	var start = -1, end = -1, verLen = 0, ver = 0;
	if( appVerStr.indexOf(safariStr) > -1)
	{
		start = appVerStr.indexOf(verStartStr);
		if (start > -1)
		{
			start = start+verStartStr.length;
			end = appVerStr.indexOf(verEndStr, start);
			verLen = end-start;
			
			if (end > -1)
			{
				ver = parseInt(appVerStr.substr( start, verLen ));
				if (ver > 3)
					result = true;
			}
		}
	}
	return result;
}

function isIE()
{
	var result = false;
	var targ = "MSIE";
	var av = navigator.userAgent;
	var start = av.indexOf(targ);
	if( start > -1 )
	{
		result = true;
	}
	return result;
}
	
function isIE7()
{
	var result = false;
	var targ = "MSIE 7.0";
	var av = navigator.userAgent;
	var start = av.indexOf(targ);
	if( start > -1 )
	{
		result = true;
	}
	return result;
}
	
function IWPObj()
{
	/***** utility methods *****************************************/
	
	this.addOrReplaceTextNode = function( doc, objID, str, replace )
	{
		if( doc != null && objID != null && str != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
			{
				var txt = doc.createTextNode( str );
				if( replace != null )
				{
					if( obj.hasChildNodes() )
					{
						if( obj.childNodes.length > replace )
						{
							var node = obj.childNodes.item( replace );
							obj.replaceChild( txt, node );
						}
						else
							obj.appendChild( txt );
					}
					else
						obj.appendChild( txt );
				}
				else
					obj.appendChild( txt );
			}
		}
	}
	
	this.cgiPath = function()
	{
		bFrame = this.bodyFrame;
		if( bFrame != null && bFrame.iwpinfo != null )
		{
			var path = bFrame.iwpinfo.cgipath;
			if( this.debugurl && bFrame.iwpinfo.debug != null  )
			{
				path = bFrame.iwpinfo.debug;
			}
			return path;
		}
		else
			return null;
	}
	
	this.checkForSafari10 = function()
	{
		var result = false;
		var targ = "AppleWebKit";
		var av = navigator.appVersion;
		var start = av.indexOf(targ);
		if( start > -1 )
		{
			start = start + targ.length + 1;
			var end = av.indexOf(" ", start) - start;
			vers = parseFloat( av.substr( start, end ) );
			if( vers < 103 )
				result = true;
		}
		return result;
	}
	
	this.executebuttonscript = function executebuttonscript( index, parentrecid, childrecid )
	{
		if( index != null )
			this.submitandperformactionscript("-buttonscript", index, parentrecid, childrecid);
	}
	
	this.activatetabscript = function activatetabscript( index, parentrecid, childrecid )
	{
		if( index != null )
			this.submitandperformactionscript("-activatetab", index, parentrecid, childrecid);
	}
	
	this.submitandperformactionscript = function submitandperformactionscript( action, index, parentrecid, childrecid )
	{
		if( index != null )
			if ( parentrecid != null && childrecid != null )
				this.submitAndContinue( [{target: "-type", n: "-index", v: index},
					{target: "-omitstate", n: "-recid", v: parentrecid},
					{target: "-relatedrecid", n: "-relatedrecid", v: childrecid},
					{target: "-submitclose", n: action, v: ""}] );
			else
			//	if there is no recid execute the buttonscript without specifying it
				this.submitAndContinue( [{target: "-type", n: "-index", v: index},
					{target: "-submitclose", n: action, v: ""}] );
	}
	
	this.objectEnabled = function objectEnabled( obj )
	{
		if( obj != null && obj.id != null && this.objstate != null )
		{
			var state = this.objstate[obj.id];
			if( state != null )
				return ! state;
		}
		return false;
	}
	
	this.openUrlWindows = function( args )
	{
		if( args != null && args.length )
		{
			for( var i in args )
			{
			
			//	if false then popups are being blocked
				if (!window.open( args[i] ))
				{
					alert(this.strings.form_popups_blocked);
					break;
				}
			}
		}
	}
	
	this.setAltAttributes = function( doc, objID, str )
	{
		if( doc != null && objID != null && str != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
			{
				obj.setAttribute( "title", str );
				obj.setAttribute( "alt", str );
			}
		}
	}
	
	this.setAttribute = function( doc, objID, att, val )
	{
		if( doc != null && objID != null && att != null && val != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
				obj.setAttribute( att, val );
		}
	}
	
	this.setImgButtonState = function( doc, buttonId, labelId, img, disabled )
	{
		if( doc != null && buttonId != null )
		{
			if (img != null)
			{
				var url = this.imgPath + img;
				if( disabled == null ) disabled = false;
				if( disabled )
					url += "_x.png";
				else
					url += "_n.png";
				var obj = doc.getElementById( buttonId );
				if( obj != null )
					obj.src = url;
			}
			this.objstate[buttonId] = disabled;
			
			if (labelId != null)
				this.setLabelColor( doc, labelId, disabled );
		}
	}
	
	this.setObjVisibility = function( doc, objID, visible )
	{
		if( doc != null && objID != null && visible != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
			{
				if( visible )
					obj.style.visibility = "visible";
				else
					obj.style.visibility = "hidden";
			}
		}
	}

	this.setLabelColor = function ( doc, objID, disable )
	{
		if ( doc != null && objID != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null && obj.style != null )
			{
				if (disable)
					obj.style.color = "#8c8c8c";
				else
					obj.style.color = "#000000";
			}
		}	
	}
	
	this.setTop = function( doc, objID, pos )
	{
		if( doc != null && objID != null && pos != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null && obj.style != null )
				obj.style.top = parseFloat(pos) + "px";
		}
	}
	
	this.setHeight = function( doc, objID, pos )
	{
		if( doc != null && objID != null && pos != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null && obj.style != null )
				obj.style.height = parseFloat(pos) + "px";
		}
	}
	
	this.setupRollover = function( doc, objID, name)
	{
		if( doc != null && objID != null && name != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
			{
				var baseUrl = this.imgPath + name;
				var nUrl = baseUrl + "_n.png";
				var dUrl = baseUrl + "_d.png";
				obj.images = new Array(nUrl, nUrl, dUrl);
				this.objstate[objID] = false;
			}
		}
	}
	
	this.setDisabled = function( doc, objID )
	{
		if( doc != null && objID != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
			{
				obj.disabled = true;
				this.objstate[objID] = true;
			}
		}
	}
	
	this.setEnabled = function( doc, objID )
	{
		if( doc != null && objID != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
			{
				obj.disabled = false;
				this.objstate[objID] = false;
			}
		}
	}
	
	this.setValue = function( doc, objID, val )
	{
		if( doc != null && objID != null && val != null )
		{
			var obj = doc.getElementById( objID );
			if( obj != null )
			{
				try
				{
					obj.value = val;
				}
				catch(e){}
			}
		}
	}

	this.setOperatorOption = function ( opObj, index, opStr, desc )
	{
		var s = this.statusFrame;
		opObj.options[index] = new s.Option( opStr+" "+desc, opStr );
		opObj.options[index].title = desc;
	}	
	
	this.submitAndContinue = function( args, target, formname )
	{
		var bFrame = this.bodyFrame;
		var frm = null;
		var url = this.cgiPath();
		if( formname == null )
			formname = "iwpform";
		if( bFrame != null && bFrame.document != null )
			frm = bFrame.document.getElementById( formname );	
		if( frm != null )
		{
			if( args != null )
			{
				for ( var i in args )
				{
					if( args[i].target != null  )
					{
						var obj = frm.elements[ args[i].target ];
						if( obj != null )
						{
							obj.setAttribute("name", args[i].n);
							obj.setAttribute("value", args[i].v);
						}
					}
				}
			}
			if( target != null )
				frm.setAttribute("target", target);
			if( this.debugurl )
				frm.setAttribute("action", url);
			frm.submit();
		}
		else if( args != null && url != null )
		{
			var end = args.length - 1;
			for ( var i in args )
			{
				url += args[i].n + "=" + bFrame.escape(args[i].v);
				if( i < end )
					url += "&";
			}
			if( target != null )
			{
				if( target == "_top" )
					window.location = url;
				else
					window.open( url, target, "location=yes,menubar=yes,resizable=yes,scrollbars=yes,status=yes,toolbar=yes" );
			}
			else if( bFrame != null )
				bFrame.location = url;
		}
	}
	
	this.submitFindRequest = function( args )
	{
		if( args != null )
		{
			var flag = "false";
			var sFrame = this.statusFrame;
			if ( ( sFrame != null ) && ( sFrame.document != null ) )
			{
				var omit = top.yuisupport.isOmitFindRequestSelected();
				if ( ( omit != null ) && ( omit == true ) )
					flag = "true";
			}
			args[args.length] = {target: "-omitstate", n: "-omitstate", v: flag};
			this.submitAndContinue( args );
		}
	}
	
	this.setBackground = function ( obj , buttonId , rollOver )
	{
		var sFrame = this.statusFrame;
		if ( sFrame != null && sFrame.document != null )
		{
			var button = sFrame.document.getElementById( buttonId );
			if ( obj != null )
			{
				if (rollOver && this.objectEnabled( button ))
				{
					obj.style.background = "url('images/buttonbg_o.png')";
				} else
				{
					obj.style.background = "none";
				}
			}
		}
	}
	
	this.swapToggleImage = function( obj, index )
	{
		if( obj != null && obj.images != null && index > -1 && index < 4 && this.objectEnabled( obj ) )
		{
			var img = obj.images[index];
			if( img != null )
				obj.src = img;
		}
	}
		

	this.swapImage = function( obj, objname, index )
	{
		if( obj != null && objname != null && index > -1 && index < 4 && this.objectEnabled( obj ) )
		{
			var baseUrl = this.imgPath + objname;
			var img;
			switch(index)
			{
				case 0: 
					img = baseUrl+"_n.png";
					break;
				case 2:
					img = baseUrl+"_d.png";
					break;
				default:
					break;
			}
			
			if (img != null)
			{
				obj.src = img;
			}
		}
	}
	
	this.toggleStatusArea = function toggleStatusArea( obj )
	{
		if( obj != null && this.objectEnabled( obj ) )
		{
			var status = this.statusVisible;
			var action = "-";
			if( status )
				action += "hidestatus";
			else
				action += "showstatus";
			this.submitAndContinue( [{target: "-submitclose", n: action, v: ""}], "_top" );
		}
	}
	
	this.adjustToolBarWidth = function ()
	{
		if (isStatusFrameValid())
		{
			var doc = this.statusFrame.document;
			
			var body = doc.getElementById("statusframebody");
			var totalWidth = 0;
			if (body != null && body.offsetWidth != null)
				totalWidth = body.offsetWidth;
			
			var recordBox = doc.getElementById("recordBox");
			var recordBoxWidth = 0;
			if (recordBox != null && recordBox.offsetWidth != null)
				recordBoxWidth = recordBox.offsetWidth;
			
			var statusBox = doc.getElementById("statusBox");
			var statusBoxWidth = 0;
			if (statusBox != null && statusBox.offsetWidth != null)
				statusBoxWidth = statusBox.offsetWidth;
			
			if (totalWidth != 0 || recordBoxWidth != 0 || statusBoxWidth != 0)
			{
				var scriptPanel = doc.getElementById("buttonPanel");
				var scriptBoxLeftAmount = 0;
				var unavailableWidth = 0;
				var newToolBarWidth = totalWidth-recordBoxWidth-statusBoxWidth;
				var statusBoxLeftAmount = recordBoxWidth;					
				var mode = this.bodyFrame.iwpinfo.mode;
				var scriptAllowAbort = this.bodyFrame.iwpinfo.dontallowabort;
				var toolBoxObj;
								
				if (mode == this.findMode)
				{
					var findPanel = doc.getElementById("findPanel");
					var findToolBox = doc.getElementById("findToolBox");
					var browseToolBox = doc.getElementById("toolBox");
					var navPanelOffset = browseToolBox.offsetLeft-findToolBox.offsetLeft;
					unavailableWidth = findPanel.offsetLeft+findPanel.offsetWidth;
					newToolBarWidth += navPanelOffset;
					statusBoxLeftAmount -= navPanelOffset;
					toolBoxObj = findToolBox;
					
					if (isIE7())
					{
						var reqActionBox = doc.getElementById("requestActionToolBox");
						reqActionBox.style.width = "auto";
					}
				}
				else if (mode != this.browseMode && this.bodyFrame.iwpinfo.confirm)
				{
					var navPanel = doc.getElementById("navPanel");
					if (navPanel != null)
						unavailableWidth = navPanel.offsetWidth;
					
					toolBoxObj = doc.getElementById("submitPanel");
				}
				else
				{
					var navPanel = doc.getElementById("navPanel");
					if (navPanel != null)
						unavailableWidth = navPanel.offsetWidth;
					
					toolBoxObj = doc.getElementById("toolBox");
				
					if (isIE7())
					{
						var extraBox = doc.getElementById("extraToolBox");
						extraBox.style.width = "auto";
					}
				}
				
				if (toolBoxObj != null && toolBoxObj.style != null)
				{
					if (newToolBarWidth > 0)
						toolBoxObj.style.width = newToolBarWidth+"px";
					
					if (statusBox != null && statusBox.style != null)
					{
						statusBoxLeftAmount += toolBoxObj.offsetWidth;
						
						if (statusBoxLeftAmount > 0)
							statusBox.style.left = statusBoxLeftAmount+"px";
					}
				}
				
				if (scriptPanel != null && unavailableWidth > 0)
				{
					var scriptPanelWidth = scriptPanel.offsetWidth;
					if (scriptAllowAbort)
					{
						var scriptCancelPanel = doc.getElementById("cancelScriptBox");
						if (scriptCancelPanel != null)
						{
							scriptPanelWidth -= scriptCancelPanel.offsetWidth;
						}
					}
					
					var extraWidth = totalWidth-scriptPanelWidth-unavailableWidth;
					if (extraWidth < 0)
						scriptBoxLeftAmount = unavailableWidth;
					else
						scriptBoxLeftAmount = unavailableWidth+extraWidth;
					
					if (scriptBoxLeftAmount > 0)
						scriptPanel.style.left = scriptBoxLeftAmount+"px";
				}
			}
		}
	}
	
	this.unimplemented = function()
	{
		alert("Unimplemented!");
	}
	
	/***** setup methods *****************************************/
	
	this.setStatusAreaCSS = function()
	{
		if (isStatusFrameValid())
		{
			var cssFile = '';
			var lang = top.iwp.bodyFrame.iwpinfo.language;
						
			if (lang != null)
			{
				switch(lang)
				{	
					case 'eng':
						//cssFile = 'eng/iwp.css';
						break;
					case 'chs':
						cssFile = 'chs/iwp.css';
						break;
					case 'cht':
						cssFile = 'cht/iwp.css';
						break;
					case 'deu':
						cssFile = 'deu/iwp.css';
						break;	
					case 'fre':
						cssFile = 'fre/iwp.css';
						break;
					case 'ita':
						cssFile = 'ita/iwp.css';
						break;
					case 'jpn':
						cssFile = 'jpn/iwp.css';
						break;
					case 'nld':
						cssFile = 'nld/iwp.css';
						break;
					case 'spa':
						cssFile = 'spa/iwp.css';
						break;
					case 'swe':
						cssFile = 'swe/iwp.css';
						break;	
					default:
						break;
				}
			}
							
			if (cssFile != '')
			{
				var doc = top.iwp.statusFrame.document;
				var headID = doc.getElementsByTagName("head")[0];
				var cssNode = doc.createElement('link');
				cssNode.type = 'text/css';
				cssNode.rel = 'stylesheet';
				cssNode.href = cssFile;
				headID.appendChild(cssNode);
			}
		}
	}
	
	this.setupControlFrame = function setupControlFrame( win, info )
	{
		this.controlFrame = win;
		var cFrame = this.controlFrame;
		if( this.strings != null && cFrame != null && cFrame.document != null )
		{
			var strs = this.strings;
			var statusVisible = this.statusVisible;
			var c = cFrame.document;
			if( statusVisible )
			{
				this.setAltAttributes( c, "toggleButton", strs.cont_hlp_collapse );
				this.setupRollover( c, "toggleButton", "collapse" );
			}
			else
			{
				this.setAltAttributes( c, "toggleButton", strs.cont_hlp_expand );
				this.setupRollover( c, "toggleButton", "expand" );
			}
			this.setTop( c, "toggleButton", 2 );
			var hide = true;
			var bFrame = this.bodyFrame;
			if( bFrame != null && bFrame.iwpinfo != null )
			{
				hide = bFrame.iwpinfo.locked;
				
				if (hide)
				{
					this.setTop( c, "toggleButton", 0 );
				}
				
			//	show the control frame if it's hidden, but not locked; fix for 76998	
				var controlBar = window.document.getElementById("controlFrame");
				if (controlBar != null)
				{
					if (statusVisible == false)
					{
						if (bFrame.iwpinfo.locked == 0)
						{
							controlBar.style.height = "12px";
							controlBar.style.visibility = "visible";
						}
						else
						{
							controlBar.style.height = "0px";
							controlBar.style.visibility = "hidden";
						}
					}
				}
			}
			this.setImgButtonState( c, "toggleButton", null, "collapse", hide );
			this.swapToggleImage( c.getElementById( "toggleButton" ), 0 );
			if( info == null && this.bodyFrame != null )
				info = this.bodyFrame.iwpinfo;
			if( info != null && info.locked )
				this.setImgButtonState( c, "toggleButton", null, "collapse", true );
		}
	}

	this.setupToolBarMinWidths = function ()
	{
		if (isStatusFrameValid())
		{
			var lang = this.bodyFrame.iwpinfo.language;
			var doc = this.statusFrame.document;
			var browseModeToolBar = doc.getElementById("toolBox"); 
			var findModeToolBar = doc.getElementById("findToolBox");
			var editModeToolBar = doc.getElementById("submitPanel");
			var statusBox = doc.getElementById("statusBox");
			var findPanel = doc.getElementById("findPanel");
			var navPanel = doc.getElementById("navPanel");
			var recordBox = doc.getElementById("recordBox");
			var scriptPanel = doc.getElementById("buttonPanel");
			
			var px = "px";
			browseModeToolBar.style.minWidth = 460+px;
			findModeToolBar.style.minWidth = 400+px;
			editModeToolBar.style.minWidth = 300+px;
					
			switch(lang)
			{	
				case 'eng':
					findPanel.style.width = 400+px;
					navPanel.style.width = 330+px;
					break;					
				case 'chs':
					browseModeToolBar.style.left = 280+px;
					editModeToolBar.style.left = 280+px;
					findPanel.style.width = 350+px;
					findPanel.style.left = 335+px;
					navPanel.style.width = 340+px;
					break;	
				case 'cht':
					findPanel.style.width = 370+px;
					findPanel.style.left = 320+px;
					navPanel.style.width = 330+px;
					break;					
				case 'jpn':	
					browseModeToolBar.style.minWidth = 530+px;
					browseModeToolBar.style.left = 300+px;
					findPanel.style.width = 410+px;
					findPanel.style.left = 420+px;
					editModeToolBar.style.left = 300+px;
					navPanel.style.width = 450+px;
					recordBox.style.width = 300+px;
					statusBox.style.width = 180+px;
					scriptPanel.style.width = 315+px;
					break;									
				case 'deu':
					browseModeToolBar.style.minWidth = 410+px;
					browseModeToolBar.style.left = 290+px;
					findModeToolBar.style.left = 230+px;
					editModeToolBar.style.left = 290+px;
					findPanel.style.width = 470+px;
					navPanel.style.width = 330+px;
					recordBox.style.width = 290+px;
					scriptPanel.style.width = 300+px;
					break;					
				case 'fre':
					browseModeToolBar.style.minWidth = 450+px;
					browseModeToolBar.style.left = 280+px;
					findModeToolBar.style.minWidth = 410+px;
					findModeToolBar.style.left = 250+px;
					editModeToolBar.style.left = 280+px;
					findPanel.style.left = 380+px;
					findPanel.style.width = 480+px;
					navPanel.style.width = 380+px;
					statusBox.style.width = 180+px;
					recordBox.style.width = 280+px;
					break;	
				case 'ita':
					browseModeToolBar.style.minWidth = 505+px;
					browseModeToolBar.style.left = 300+px;
					findModeToolBar.style.minWidth = 430+px;
					editModeToolBar.style.left = 300+px;
					findPanel.style.width = 450+px;
					navPanel.style.width = 345+px;
					recordBox.style.width = 300+px;
					break;	
				case 'nld':
					browseModeToolBar.style.minWidth = 560+px;
					browseModeToolBar.style.left = 300+px;
					findModeToolBar.style.minWidth = 560+px;
					findModeToolBar.style.left = 215+px;
					editModeToolBar.style.left = 300+px;
					findPanel.style.width = 495+px;
					findPanel.style.left = 360+px;
					navPanel.style.width = 365+px;
					recordBox.style.width = 300+px;
					scriptPanel.style.width = 300+px;
					break;	
				case 'spa':
					browseModeToolBar.style.minWidth = 500+px;
					findModeToolBar.style.minWidth = 445+px;
					browseModeToolBar.style.left = 310+px;
					editModeToolBar.style.left = 310+px;
					findPanel.style.width = 440+px;
					findPanel.style.left = 370+px;
					navPanel.style.width = 365+px;
					statusBox.style.width = 180+px;
					recordBox.style.width = 320+px;
					break;	
				case 'swe':
					browseModeToolBar.style.left = 310+px;
					editModeToolBar.style.left = 310+px;
					findPanel.style.width = 430+px;
					navPanel.style.width = 340+px;
					recordBox.style.width = 310+px;
					break;	
				default:
					break;
			}
		}
	}
		
	this.setupStatusFrame = function( frame )
	{
		if( frame != null && this.strings != null )
		{
			this.statusFrame = frame;
			var strs = this.strings;
			var sFrame = this.statusFrame;
			if( sFrame.document != null )
			{
				var s = sFrame.document;
				this.addOrReplaceTextNode( s, "viewttlBox", strs.stat_lbl_viewas );
				this.addOrReplaceTextNode( s, "layttlBox", strs.stat_lbl_lay );
				this.addOrReplaceTextNode( s, "scriptSpan", strs.stat_lbl_script );
				this.addOrReplaceTextNode( s, "findTotalTxt", strs.stat_lbl_total );
				
				this.addOrReplaceTextNode( s, "showallLabel", strs.stat_lbl_showall );
				this.addOrReplaceTextNode( s, "newLabel", strs.stat_lbl_new );
				this.addOrReplaceTextNode( s, "editLabel", strs.stat_lbl_edit );
				this.addOrReplaceTextNode( s, "deleteLabel", strs.stat_lbl_del );
				this.addOrReplaceTextNode( s, "recLabel", strs.stat_lbl_rec );
				this.addOrReplaceTextNode( s, "findLabel", strs.stat_lbl_find );
				this.addOrReplaceTextNode( s, "sortLabel", strs.stat_lbl_sortButton );
				
				this.addOrReplaceTextNode( s, "homeLabel", strs.stat_lbl_home );
				this.addOrReplaceTextNode( s, "logoutLabel", strs.stat_lbl_logout );
				this.addOrReplaceTextNode( s, "helpLabel", strs.stat_lbl_help );
				
				this.addOrReplaceTextNode( s, "submitLabel", strs.stat_lbl_submit );
				this.addOrReplaceTextNode( s, "cancelLabel", strs.stat_lbl_cancel );
				this.addOrReplaceTextNode( s, "resetLabel", strs.stat_lbl_revert );
				
				this.addOrReplaceTextNode( s, "newreqLabel", strs.stat_lbl_newreq );
				this.addOrReplaceTextNode( s, "delreqLabel", strs.stat_lbl_delreq );
				this.addOrReplaceTextNode( s, "reqLabel", strs.stat_lbl_req );
				this.addOrReplaceTextNode( s, "performFindLabel", strs.stat_lbl_pfind );
				this.addOrReplaceTextNode( s, "cancelFindLabel", strs.stat_lbl_cancelfind );
				this.addOrReplaceTextNode( s, "omitFindLabel", strs.stat_lbl_omitfind );
				this.addOrReplaceTextNode( s, "symbolLabel", strs.stat_lbl_sym );
								
				this.setAltAttributes( s, "showallButton", strs.stat_hlp_all );
				this.setAltAttributes( s, "newButton", strs.stat_hlp_new );
				this.setAltAttributes( s, "editButton", strs.stat_hlp_edit );
				this.setAltAttributes( s, "deleteButton", strs.stat_hlp_del );
				this.setAltAttributes( s, "sortButton", strs.stat_hlp_sort );
								
				this.setAltAttributes( s, "homeButton", strs.stat_hlp_home );
				this.setAltAttributes( s, "logoutButton", strs.stat_hlp_logout );
				this.setAltAttributes( s, "mainhelpButton", strs.stat_hlp_help );
				
				this.setAltAttributes( s, "submitButton", strs.stat_hlp_submit );
				this.setAltAttributes( s, "cancelButton", strs.stat_hlp_cancel );
				this.setAltAttributes( s, "resetButton", strs.stat_hlp_undoedit );
				
				this.setAltAttributes( s, "symbolpopup", strs.stat_hlp_syms );
				
				this.setAltAttributes( s, "newReqButton", strs.stat_hlp_newreq );
				this.setAltAttributes( s, "delReqButton", strs.stat_hlp_delreq );
				this.setAltAttributes( s, "performFindButton", strs.stat_hlp_pfind );
				this.setAltAttributes( s, "cancelFindButton", strs.stat_hlp_cancelfind );
				
				this.setAltAttributes( s, "pieImg", strs.stat_hlp_pie );
				this.setAltAttributes( s, "laypopup", strs.stat_hlp_laypopup );	
												
				this.setValue( s, "contScriptButton", strs.stat_btn_cont );
				this.setValue( s, "cancelScriptButton", strs.stat_btn_cancel );
				
				var obj = s.getElementById("symbolpopup");
				if( obj != null && obj.options != null )
				{
					obj.options[0] = new sFrame.Option( strs.stat_pop_syms );
					this.setOperatorOption( obj, 1, "=", strs.stat_pop_equ);
					this.setOperatorOption( obj, 2, "==", strs.stat_pop_cont);
					this.setOperatorOption( obj, 3, "!", strs.stat_pop_dups);
					this.setOperatorOption( obj, 4, "<", strs.stat_pop_lt);
					this.setOperatorOption( obj, 5, "<=", strs.stat_pop_lte);
					this.setOperatorOption( obj, 6, ">", strs.stat_pop_gt);
					this.setOperatorOption( obj, 7, ">=", strs.stat_pop_gte);
					this.setOperatorOption( obj, 8, "...", strs.stat_pop_range);
					this.setOperatorOption( obj, 9, "//", strs.stat_pop_today);
					this.setOperatorOption( obj, 10, "?", strs.stat_pop_inval);
					this.setOperatorOption( obj, 11, "@", strs.stat_pop_onechar);
					this.setOperatorOption( obj, 12, "#", strs.stat_pop_onedigit);
					this.setOperatorOption( obj, 13, "*", strs.stat_pop_zero);
					this.setOperatorOption( obj, 14, "\\", strs.stat_pop_esc);
					this.setOperatorOption( obj, 15, '""', strs.stat_pop_matstart);
					this.setOperatorOption( obj, 16, '*""', strs.stat_pop_matany);
					this.setOperatorOption( obj, 17, "~", strs.stat_pop_relax);
										
					if (isIE())
					{
						obj.options[1].label = "= " + strs.stat_pop_equ_short;
						obj.options[15].label = '"" ' + strs.stat_pop_matstart_short;
						obj.options[16].label = '*"" ' + strs.stat_pop_matany_short;
						obj.options[17].label = "~ " + strs.stat_pop_relax_short;
						
						var lang = top.iwp.bodyFrame.iwpinfo.language;
						
						if (lang != null)
						{
							switch(lang)
							{	
								case 'deu':
									obj.options[2].label = "== " + strs.stat_pop_cont_short;
									obj.options[10].label = "? " + strs.stat_pop_inval_short;
									obj.options[11].label = "@ " + strs.stat_pop_onechar_short;
									obj.options[13].label = "* " + strs.stat_pop_zero_short;
									obj.options[14].label = "\\ " + strs.stat_pop_esc_short;
									break;	
								case 'fre':
									obj.options[13].label = "* " + strs.stat_pop_zero_short;
									obj.options[14].label = "\\ " + strs.stat_pop_esc_short;
									break;
								case 'ita':
									obj.options[14].label = "\\ " + strs.stat_pop_esc_short;
									break;
								case 'jpn':
									obj.options[2].label = "== " + strs.stat_pop_cont_short;
									obj.options[14].label = "\\ " + strs.stat_pop_esc_short;
									break;
								case 'nld':
									obj.options[2].label = "== " + strs.stat_pop_cont_short;
									obj.options[3].label = "! " + strs.stat_pop_dups_short;
									obj.options[7].label = ">= " + strs.stat_pop_gte_short;
									obj.options[14].label = "\\ " + strs.stat_pop_esc_short;
									break;
								case 'spa':
									obj.options[2].label = "== " + strs.stat_pop_cont_short;
									obj.options[3].label = "! " + strs.stat_pop_dups_short;
									obj.options[14].label = "\\ " + strs.stat_pop_esc_short;
									break;
								case 'swe':
									obj.options[5].label = "<= " + strs.stat_pop_lte_short;
									obj.options[10].label = "? " + strs.stat_pop_inval_short;
									break;	
								default:
									break;
							}
						}
					}
					
					obj.options[0].selected = true;
				}
				
				this.setupToolBarMinWidths();
				this.setStatusAreaCSS();
				this.updateStatusFrame();
			}
		}
	}
	
	this.setupTopFrame = function setupTopFrame( statVis, statusLocked )
	{
		if( this.strings != null && statVis != null && statusLocked != null )
		{
			this.statusVisible = statVis;
			this.statusLocked = statusLocked;
			if( document != null )
				document.title = this.strings.home_ttl_iwp;
		}
	}
	
	this.updateNavPanel = function( win, info, strs )
	{
		if( win != null && info != null && strs != null )
		{
			var obj = null;
			var doc = win.document;
			if( doc != null )
			{
				obj = doc.getElementById("laypopup");
				if( obj != null && obj.options != null )
				{
					var opts = obj.options;
					var lays = info.layouts;
					var index = lays[0];
					opts.length = 0;
					for( var i = 1; i < lays.length; ++i, ++index )
					{
						var opt = new win.Option(lays[i], index );
						opts[i-1] = opt;
					}
					index = 0;
					if( info.lay > 0 )
						index = info.lay - lays[0];
					opts[index].selected = true;
				}
	
				obj = doc.getElementById("viewbuttons");
                
                if (obj != null) {
                    if (info.viewas == "form") {
                        top.yuisupport.selectViewButton(0);
                    }
                    else 
                        if (info.viewas == "list") {
                            top.yuisupport.selectViewButton(1);
                        }
                        else 
                            if (info.viewas == "table") {
                                top.yuisupport.selectViewButton(2);
                            }
                }
			
				var modeTitle = ""; 								
				if( info.viewas != "form" )
				{
					var rangemax = info.found;
					var end = info.recnum + info.pagesize - 1;
							
					if( end > rangemax )
						end = rangemax;
			
					modeTitle = " ("+info.recnum+" - "+end+" )";
				}

				if (info.mode == this.findMode)
				{
					modeTitle = strs.stat_lbl_reqTitle+modeTitle;
					this.addOrReplaceTextNode( doc, "requestsTitle", modeTitle, 0 );
				}			
				else 
				{
					modeTitle = strs.stat_lbl_currec+modeTitle;
					this.addOrReplaceTextNode( doc, "recordTitle", modeTitle, 0 );
				}
			}
		}
	}
	
	this.setToobarState = function( doc, info, disable )
	{
		if( doc != null && info != null && disable  != null )
		{
			var scriptPaused = info.paused;
			
			if( info.cannew && !scriptPaused )
			{
				this.setImgButtonState( doc, "newButton", "newLabel", "new", disable );
			}
			else
			{
				this.setImgButtonState( doc, "newButton", "newLabel", "new", true );
			}
					
			if( info.canedit )
			{
				this.setImgButtonState( doc, "editButton", "editLabel", "edit", disable );
			}
			else
			{
				this.setImgButtonState( doc, "editButton", "editLabel", "edit", true );
			}
			
			if( info.candupe && !scriptPaused )
			{
				top.yuisupport.setMenuItemAccessibility("recMenuButton", top.yuisupport.duprec, disable);
			}
			else
			{
				top.yuisupport.setMenuItemAccessibility("recMenuButton", top.yuisupport.duprec, true);
			}
			
			if( info.candelete && info.recnum > 0 && !scriptPaused )
			{
				this.setImgButtonState( doc, "deleteButton", "deleteLabel", "delete", disable );
			}
			else
			{
				this.setImgButtonState( doc, "deleteButton", "deleteLabel", "delete", true );
			}
			
			if ( info.recnum > 0 && !scriptPaused )
			{
				top.yuisupport.setMenuItemAccessibility("recMenuButton", top.yuisupport.omitcurr, disable);
				top.yuisupport.setMenuItemAccessibility("recMenuButton", top.yuisupport.omitmulti, disable);
			}
			else
			{
				top.yuisupport.setMenuItemAccessibility("recMenuButton", top.yuisupport.omitcurr, true);
				top.yuisupport.setMenuItemAccessibility("recMenuButton", top.yuisupport.omitmulti, true);
			}	
			
			this.setImgButtonState( doc, "sortButton", "sortLabel", "sort", disable || info.found == 0 ||scriptPaused );
			
			this.setImgButtonState( doc, "showallButton", "showallLabel", "showall", disable || info.total == 0 || info.total == info.found || scriptPaused );
			
			top.yuisupport.setMenuItemAccessibility("recMenuButton", top.yuisupport.showomit, disable || scriptPaused );
		}
	}
	
	this.updateStatusFrame = function updateStatusFrame( win )
	{
		if( win != null )
			this.bodyFrame = win;
		var bFrame = this.bodyFrame;
		if( bFrame != null && bFrame.iwpinfo != null )
		{
			var info = bFrame.iwpinfo;
			
			if((this.statusVisible != info.visible) || (this.statusLocked != info.locked))
			{
				var url = this.cgiPath()
				if( url != null )
				{
					url += "-db=" + info.db.url + "&-loadframes";
					window.location = url;
					return;
				}
			}
			this.setupControlFrame( this.controlFrame, info );
			this.openUrlWindows( info.urls );

		//	update the title here; fix for 76808; custom title not updated when status is closed
			document.title = info.windowtitle;

			if( ! this.statusVisible )
				return;
			var sFrame = this.statusFrame;
			if( sFrame != null && sFrame.document != null && this.strings != null )
			{
				var s = sFrame.document;
				var strs = this.strings;
				var scriptPaused = info.paused;
				
				this.setObjVisibility( s, "statusBox", true );
				this.setObjVisibility( s, "moveBox", true );
				this.setObjVisibility( s, "prevBox", true );
				this.setObjVisibility( s, "nextBox", true );
					
				if (isSafari4Plus() && isWindows())
					this.setTop( s, "viewbuttons", 2);
				else
					this.setTop( s, "viewbuttons", 3.5);
				
				if (isWindows())
				{
					this.setHeight( s, "contScriptButton", 19);
					this.setHeight( s, "cancelScriptButton", 19);
				} else
				{
					this.setHeight( s, "contScriptButton", 17);
					this.setHeight( s, "cancelScriptButton", 17);
				}
				
				this.updateNavPanel( sFrame, info, strs );
				
				if( info.debug != null )
					this.setObjVisibility( s, "debugBox", true );
				if( info.mode == this.findMode )
				{
					this.setObjVisibility( s, "toolBox", false );
					this.setObjVisibility( s, "submitPanel", false );
					this.setObjVisibility( s, "recordTitle", false );
					this.setObjVisibility( s, "pieBox", false);
					this.setObjVisibility( s, "totalOrFoundTxt", false);
					
					if (info.found > 0)
						this.setEnabled ( s, "recnumField" );
					else
						this.setDisabled ( s, "recnumField"); 
					
					this.setEnabled ( s, "laypopup" );
					
					if (scriptPaused)
					{
						top.yuisupport.enableViewButton(0, false);
						top.yuisupport.enableViewButton(1, false);
						top.yuisupport.enableViewButton(2, false);
						this.setImgButtonState( s, "performFindButton", "performFindLabel", "performfind", true );
						top.yuisupport.setMenuItemAccessibility("reqMenuButton", top.yuisupport.efind, true);
						top.yuisupport.setMenuItemAccessibility("reqMenuButton", top.yuisupport.cfind, true);
						top.yuisupport.setMenuItemAccessibility("reqMenuButton", top.yuisupport.revertreq, true);
						if (info.dontallowabort)
						{
							this.setImgButtonState( s, "cancelFindButton", "cancelFindLabel", "cancelfind", true );
						}
						else
						{
							this.setImgButtonState( s, "cancelFindButton", "cancelFindLabel", "cancelfind", false );
						}
					} else
					{
						top.yuisupport.enableViewButton(0, info.formviewenabled == true);
						top.yuisupport.enableViewButton(1, info.listviewenabled == true);
						top.yuisupport.enableViewButton(2, info.tableviewenabled == true);
						this.setImgButtonState( s, "performFindButton", "performFindLabel", "performfind", false );
						this.setImgButtonState( s, "cancelFindButton", "cancelFindLabel", "cancelfind", false );
						top.yuisupport.setMenuItemAccessibility("reqMenuButton", top.yuisupport.efind, info.total <= 0 );
						top.yuisupport.setMenuItemAccessibility("reqMenuButton", top.yuisupport.cfind, info.total <= 0 );
						top.yuisupport.setMenuItemAccessibility("reqMenuButton", top.yuisupport.revertreq, info.total <= 0 );
					}
					
					if (info.omitstate == 0)
						top.yuisupport.setOmitButtonSelected(false);
					else
						top.yuisupport.setOmitButtonSelected(true);
					
					this.setImgButtonState( s, "homeButton", "homeLabel", "home", false );
					this.setImgButtonState( s, "logoutButton", "logoutLabel", "logout", false );
					this.setImgButtonState( s, "mainhelpButton", "helpLabel", "help", false );
					
					this.setImgButtonState( s, "reqButton", "reqLabel", null, false );
					this.setImgButtonState( s, "newReqButton", "newreqLabel", "newreq", false );	
					this.setImgButtonState( s, "delReqButton", "delreqLabel", "delreq", info.total <= 1 );
									
					this.setImgButtonState( s, "prevButton", null, "previous", info.recnum <= 1 );
					this.setImgButtonState( s, "nextButton", null, "next", info.recnum == info.total );
										
					this.setValue( s, "recnumField", info.recnum );
					
					this.setAltAttributes( s, "recnumField", strs.stat_hlp_cureq );
					this.setAltAttributes( s, "slider", strs.stat_hlp_sliderreq );	
					this.setAltAttributes( s, "prevButton", strs.stat_hlp_prevreq );
					this.setAltAttributes( s, "nextButton", strs.stat_hlp_nextreq );
					
					this.addOrReplaceTextNode( s, "recordRange", info.total, 0 );
					
					this.setObjVisibility( s, "findToolBox", true );
					this.setObjVisibility( s, "findPanel", true );
					this.setObjVisibility( s, "findRecordPanel", true );
					this.setObjVisibility( s, "reqGraphicBox", true);
					this.setObjVisibility( s, "requestsTitle", true );
					this.setObjVisibility( s, "findTotalTxt", true);
					
					top.yuisupport.setMenuItemAccessibility("reqMenuButton", top.yuisupport.dupreq, info.total <= 0);
										
					top.yuisupport.updateSlider();
					if (info.total <= 1)
						top.yuisupport.disableSlider();
					else 
						top.yuisupport.enableSlider();
				}
				else if( info.mode != this.browseMode && info.confirm )
				{
					this.showPieChart();
					this.setObjVisibility( s, "findToolBox", false );
					this.setObjVisibility( s, "findPanel", false );
					this.setObjVisibility( s, "findRecordPanel", false );
					this.setObjVisibility( s, "toolBox", false );
					this.setObjVisibility( s, "reqGraphicBox", false);
					this.setObjVisibility( s, "requestsTitle", false );
					
					var sortState = strs.stat_lbl_unsort;
					if( info.sorted )
						sortState = strs.stat_lbl_sort;
					
					this.setObjVisibility( s, "totalOrFoundTxt", true);
					this.setObjVisibility( s, "findTotalTxt", false);
					
					if (info.total == info.found)
					{
						this.addOrReplaceTextNode( s, "totalOrFoundTxt", strs.stat_lbl_total+sortState, 0 );
						this.addOrReplaceTextNode( s, "recordRange", info.total, 0 );
					} else
					{
						this.addOrReplaceTextNode( s, "totalOrFoundTxt", strs.stat_lbl_found+sortState, 0 );
						this.addOrReplaceTextNode( s, "recordRange", info.found+" / "+info.total , 0 );
					}
					
					this.setValue( s, "recnumField", info.recnum );
					this.setDisabled ( s, "recnumField" );
					this.setDisabled ( s, "pieLink" );
					this.setDisabled ( s, "laypopup" );
					top.yuisupport.enableViewButton(0, false);
                    top.yuisupport.enableViewButton(1, false);
                    top.yuisupport.enableViewButton(2, false);
					
					this.setImgButtonState( s, "homeButton", "homeLabel", "home", true );
					this.setImgButtonState( s, "logoutButton", "logoutLabel", "logout", true );
					this.setImgButtonState( s, "mainhelpButton", "helpLabel", "help", false );
					
					this.setImgButtonState( s, "resetButton", "resetLabel", "undo", false );
					this.setImgButtonState( s, "submitButton", "submitLabel", "submit", false );
					this.setImgButtonState( s, "cancelButton", "cancelLabel", "cancel", false );
					
					this.setImgButtonState( s, "prevButton", null, "previous", true );
					this.setImgButtonState( s, "nextButton", null, "next", true );
					
					this.setObjVisibility( s, "submitPanel", true );
					this.setObjVisibility( s, "recordTitle", true );
					this.setObjVisibility( s, "pieBox", true);	
					
					this.setAltAttributes( s, "recnumField", strs.stat_hlp_curec );
					this.setAltAttributes( s, "slider", strs.stat_hlp_slider );	
					this.setAltAttributes( s, "prevButton", strs.stat_hlp_prev );
					this.setAltAttributes( s, "nextButton", strs.stat_hlp_next );
					
					top.yuisupport.updateSlider();
					top.yuisupport.disableSlider();
				}
				else
				{
					this.showPieChart();
					this.setObjVisibility( s, "findToolBox", false );
					this.setObjVisibility( s, "submitPanel", false );
					this.setObjVisibility( s, "findPanel", false );
					this.setObjVisibility( s, "reqGraphicBox", false);
					this.setObjVisibility( s, "requestsTitle", false );
					this.setValue( s, "recnumField", info.recnum );
					var prev = strs.stat_hlp_prev;
					var next = strs.stat_hlp_next;
					
					var sortState = strs.stat_lbl_unsort;
					if( info.sorted )
						sortState = strs.stat_lbl_sort;
					
					this.setObjVisibility( s, "totalOrFoundTxt", true);
					this.setObjVisibility( s, "findTotalTxt", false);
						
					if (info.total == info.found)
					{
						this.addOrReplaceTextNode( s, "totalOrFoundTxt", strs.stat_lbl_total+sortState, 0 );
						this.addOrReplaceTextNode( s, "recordRange", info.total, 0 );
					} else
					{
						this.addOrReplaceTextNode( s, "totalOrFoundTxt", strs.stat_lbl_found+sortState, 0 );
						this.addOrReplaceTextNode( s, "recordRange", info.found+" / "+info.total , 0 );
					}
					
					this.setToobarState( s, info, false );
					this.setObjVisibility( s, "toolBox", true );
					
					if (info.found > 0)
						this.setEnabled ( s, "recnumField" );
					else
						this.setDisabled ( s, "recnumField"); 
					
					if (scriptPaused)
					{
						this.setDisabled ( s, "pieLink" );
						
						top.yuisupport.enableViewButton(0, false);
						top.yuisupport.enableViewButton(1, false);
						top.yuisupport.enableViewButton(2, false);
						
						top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.modifylastfind, true);						
						if (info.dontallowabort)
						{
							top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.createfind, true);	
							top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.allMenuItems, true);
							this.setImgButtonState( s, "findButton", "findLabel", null, true);	
						}
						else
						{
							top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.createfind, false);	
							top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.allMenuItems, false);
							this.setImgButtonState( s, "findButton", "findLabel", null, false);	
						}
					} else
					{
						if (info.total <= 0)
							this.setDisabled ( s, "pieLink" );
						else
							this.setEnabled ( s, "pieLink" );	
						
						top.yuisupport.enableViewButton(0, info.formviewenabled == true);
						top.yuisupport.enableViewButton(1, info.listviewenabled == true);
						top.yuisupport.enableViewButton(2, info.tableviewenabled == true);
						
						top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.modifylastfind, false);
						top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.createfind, false);
						top.yuisupport.setMenuItemAccessibility("findMenuButton", top.yuisupport.allMenuItems, false);
						this.setImgButtonState( s, "findButton", "findLabel", null, false);		
					}
					
					this.setEnabled ( s, "laypopup" );
										
					this.setObjVisibility( s, "recordTitle", true );
					this.setObjVisibility( s, "pieBox", true);
					
					this.setAltAttributes( s, "recnumField", strs.stat_hlp_curec );
					this.setAltAttributes( s, "slider", strs.stat_hlp_slider );	
					this.setAltAttributes( s, "prevButton", strs.stat_hlp_prev );
					this.setAltAttributes( s, "nextButton", strs.stat_hlp_next );
				
					this.setImgButtonState( s, "homeButton", "homeLabel", "home", false );
					this.setImgButtonState( s, "logoutButton", "logoutLabel", "logout", false );
					this.setImgButtonState( s, "mainhelpButton", "helpLabel", "help", false );
					
					this.setImgButtonState( s, "recButton", "recLabel", null, false );
					
					this.setImgButtonState( s, "prevButton", null, "previous", info.recnum <= 1 );
					this.setImgButtonState( s, "nextButton", null, "next", info.recnum == info.found );
					
					top.yuisupport.updateSlider();
					if (info.found <= 1)
						top.yuisupport.disableSlider();
					else 
						top.yuisupport.enableSlider();
				}
				
				if (scriptPaused)
				{
					this.setObjVisibility( s, "scriptBox", true );
				
					if (info.dontallowabort)
						this.setObjVisibility( s, "cancelScriptButton", false);
					else
						this.setObjVisibility( s, "cancelScriptButton", true);
				}
				else
				{
					this.setObjVisibility( s, "scriptBox", false );
					this.setObjVisibility( s, "cancelScriptButton", false);
				}
									
				document.title = info.windowtitle;
				this.adjustToolBarWidth();
			}
		}
	}

	/***** event methods *****************************************/

	this.focusActiveObject = function()
	{
		var bFrame = this.bodyFrame;
		if( bFrame != null && bFrame.document != null )
		{
			var fld = bFrame.document.getElementById( "active" );
			if( fld != null )
				fld.focus();
			else
			{
				var portalRow = bFrame.document.getElementById( "activeRow" );
				if( portalRow != null )
				{
					portalRow.focus();
					portalRow.blur();
				}
			}	
		}
	}
	
	this.handleBlur = function( obj )
	{
	}

	this.handleFocus = function( obj )
	{
		if( obj != null )
		{
			var bFrame = this.bodyFrame;
			if( bFrame != null && bFrame.document != null && bFrame.iwpinfo != null )
			{
				if( bFrame.iwpinfo.mode == this.findMode )
				{
					bFrame.document.activeField = obj;
					var sFrame = this.statusFrame;
					if( sFrame != null && sFrame.document != null )
					{
						var sym = sFrame.document.getElementById( "symbolpopup" );
						sym.disabled = false;
					}
				}
			}
		}
	}
	
	this.handleLoad = function()
	{
		this.focusActiveObject();
	}
		
	this.handleUnload = function()
	{
	}

	/***** action methods *****************************************/
	
	this.deleteNow = function()
	{
		var bFrame = this.bodyFrame;
		var path = this.cgiPath();
		if( bFrame != null && bFrame.iwpinfo != null && path != null )
			bFrame.location = path + "-recid=" + bFrame.iwpinfo.currecid + "&-delete";
	}

	this.deleteRecord = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("deleteButton");
			if( obj != null && this.objectEnabled( obj ) )
			{
				if (this.strings != null && confirm(this.strings.stat_ask_del)) {
					this.deleteNow();
//					top.yuisupport.adjustSliderTickSize();
				}
			}
		}
	}
	
	this.deleteRequest = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("delReqButton");
			if( obj != null && this.objectEnabled( obj ) )
				this.deleteNow();
		}
	}

	this.duplicateRecordOrRequest = function( obj )
	{
		if( obj != null && this.objectEnabled( obj ) )
		{
			var iwpinfo = this.bodyFrame.iwpinfo;
			var recID = "";
			if (iwpinfo != null)
				recid = iwpinfo.currecid;
			this.submitFindRequest( [{target: "-submitclose", n: "-duplicate", v: ""}, {target: "-recid", n: "-recid", v: recid}] );
		}
	}

	this.duplicateRecord = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("recButton");
			this.duplicateRecordOrRequest( obj );
		}
	}

	this.duplicateRequest = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("reqButton");
			this.duplicateRecordOrRequest( obj );
		}
	}

	this.editCancel = function()
	{
		var bFrame = this.bodyFrame;
		var path = this.cgiPath();
		if( bFrame != null && path != null )
			bFrame.location = path + "-canceledit";
	}
	
	this.editRecord = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("editButton");
			var iwpinfo = this.bodyFrame.iwpinfo;
			var recID = "";
			if (iwpinfo != null)
				recid = iwpinfo.currecid;
			if( obj != null && this.objectEnabled( obj ) )
				this.submitAndContinue( [{target: "-submitclose", n: "-edit", v: ""}, {target: "-recid", n: "-recid", v: recid}] );
		}
	}
	
	this.editRecById = function( recordID, activeobject, field, repetition, portalrow )
	{
		var bf = this.bodyFrame;
		if(	recordID != null
			&& activeobject != null
			&& bf != null
			&& bf.iwpinfo != null
			&& ( ! bf.iwpinfo.confirm || ( bf.iwpinfo.mode == this.findMode || bf.iwpinfo.mode == this.browseMode ) ) )
		{
			var args = new Array();
			if( bf.iwpinfo.mode == this.browseMode && field != null && field.hasChildNodes() )
			{
				var nodes = field.childNodes;
				if( nodes.length )
				{
					var isCheck = false;
					if( nodes[0].type == "checkbox" )
						args[args.length] = {target: "-field", n: nodes[0].name, v: ""};
				}
			}
			
		//	add the repetition number
			args[args.length] = {target: "-repetition", n: "-repetition", v: repetition};
		
		//	add the portal row
			args[args.length] = {target: "-portalrow", n: "-portalrow", v: portalrow};
					
			this.submitAndContinue( args.concat( [{target: "-recid", n: "-recid", v: recordID},
				{target: "-index", n: "-index", v: activeobject}] ), null, "iwpedit" );
		}
	}

	this.submitData = function( obj, overRide )
	{
		if( obj != null )
		{
			if( overRide == null )
				overRide = false;
			bFrame = this.bodyFrame;
			if( bFrame != null && bFrame.iwpinfo != null )
			{
				if( ! bFrame.iwpinfo.confirm || ( overRide || this.objectEnabled( obj ) ) )
					this.submitAndContinue();
			}
		}
	}

	this.editSubmit = function( obj )
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var submitButton = sf.document.getElementById("submitButton");
			if( obj != null && this.objectEnabled( submitButton ) )
			{			
				this.submitData( obj, true );
			}
		}
	}

	this.findOmitted = function()
	{
		this.submitAndContinue( [{target: "-submitclose", n: "-findomitted", v: ""}] );
	}
	
	this.insertSymbol = function( obj )
	{
		var bFrame = this.bodyFrame;
		if( obj != null && bFrame != null && bFrame.document != null )
		{
			var fld = bFrame.document.activeField;
			if( fld != null )
			{
				var sel = obj.selectedIndex;
				obj.selectedIndex = 0;
				if( sel > 0 && sel < obj.options.length )
				{
					var sym = obj.options[sel].value;
					fld.value = fld.value + sym;
				}
			}
		}
	}

	this.logOut = function()
	{
		if (isStatusFrameValid)
		{
			if (this.sortdialog != null)
				this.sortdialog.close();
			
			var obj = this.statusFrame.document.getElementById("logoutButton");
			if( obj != null && this.objectEnabled( obj ) )
				this.submitAndContinue( [{target: "-submitclose", n: "-close", v: ""}], "_top" );
		}
	}
	
	this.newRecordOrRequest = function( obj )
	{
		if( obj != null && this.objectEnabled( obj ) )
			this.submitFindRequest( [{target: "-submitclose", n: "-new", v: ""}] );
	}
	
	this.newRecord = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("newButton");
			this.newRecordOrRequest( obj );
		}
	}
	
	this.newRequest = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("newReqButton");
			this.newRecordOrRequest( obj );
		}
	}
	
	this.omitMultiple = function( def )
	{
		if (isStatusFrameValid())
		{
			var info = this.bodyFrame.iwpinfo;
			var omitTotal = info.found-info.recnum+1;
			var strs = this.strings;
			if( strs != null )
			{
				if( def == null )
					def = "1";
				var num = prompt( strs.stat_ask_omit, def );
				if (num != null)
				{
					var exp = new RegExp("[1-9][0-9]*");
					var numStr = num.toString();
					
					if( numStr.match(exp) == numStr )
					{
						if (num > omitTotal)
						{
							var errStr = strs.stat_err_omitManyBegin+omitTotal+strs.stat_err_omitManyEnd;
							alert(errStr);
						}
						else
							this.submitAndContinue( [{target: "-omitstate", n: "-count", v: num},{target: "-submitclose", n: "-omitmultiple", v: ""}] );
					}
					else if( num != "" )
					{
						alert(strs.stat_err_omit);
						this.omitMultiple( num );
					}
				}
			}
		}
	}
	
	this.omitSingle = function()
	{
		this.submitFindRequest( [{target: "-submitclose", n: "-omit", v: ""}] );
	}
	
	this.omitSingleRecord = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var omitButton = sf.document.getElementById("recButton");
			if( this.objectEnabled( omitButton ) )
			{			
				this.submitAndContinue( [{target: "-submitclose", n: "-omit", v: ""}] );
			}
		}
	}
	
	this.performFind = function( type )
	{
		if (isStatusFrameValid())
		{
			var args = new Array();
			
			if ( type == null )
			{
				var findButton = this.statusFrame.document.getElementById("performFindButton");
				if( !this.objectEnabled( findButton ) )
				{	
					return;
				}
			} else if ( type > 0 )
			{
				var val = "extend";
				if( type > 1 )
					val = "constrain";
				args[0] = {target: "-type", n: "-type", v: val};
			}
			this.submitFindRequest( args );
		}
	}
	
	this.resetForm = function( obj )
	{
		if( obj != null && this.objectEnabled( obj ) )
		{
			var bFrame = this.bodyFrame;
			if( bFrame != null && bFrame.document != null )
			{
				var frm = bFrame.document.getElementById( "iwpform" );
				if( frm != null )
				{
					frm.reset();
				}
			}
		}
	}
	
	this.resetEditForm = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("resetButton");
			this.resetForm( obj );
		}
	}
	
	this.resetFindForm = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("reqButton");
			this.resetForm( obj );
		}
 	}
	
	this.scriptCancel = function()
	{
		this.submitFindRequest( [{target: "-submitclose", n: "-exitscript", v: ""}] );
	}
	
	this.scriptContinue = function()
	{
		this.submitFindRequest( [{target: "-submitclose", n: "-resumescript", v: ""}] );
	}
	
	this.showAllRecordsOrRequests = function( obj )
	{
		if( obj != null && this.objectEnabled( obj ) )
		{
			this.submitFindRequest( [{target: "-submitclose", n: "-showall", v: ""}] );
			this.showPieChart();
		}
	}
	
	this.showAllRecords = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("showallButton");
			this.showAllRecordsOrRequests( obj );
		}
	}

	this.sortTableByFieldName = function( index )
	{
		var bf = this.bodyFrame;
		if( index != null && bf != null && bf.iwpinfo != null )
		{
			var info = bf.iwpinfo;
			if( ! info.confirm || ( info.mode == this.findMode || info.mode == this.browseMode ) )
			{
				var order = "ascend";
				if( info.sorted && index == info.currentorder.index && info.currentorder.order == order )
					order = "descend";
				this.submitFindRequest( [{target: "-type", n: "-sortfield.1", v: index},{target: "-omitstate", n: "-sortorder.1", v: order},{target: "-submitclose", n: "-iwpsort", v: ""}] );
			}
		}
	}

	/***** navigation methods *****************************************/

	this.goHome = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			if (this.sortdialog != null)
				this.sortdialog.close();
			var obj = sf.document.getElementById("homeButton");
			if( obj != null && this.objectEnabled( obj ) )
				this.submitAndContinue( [{target: "-submitclose", n: "-home", v: ""}], "_top" );
		}
	}
	
	this.goToBrowse = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("cancelFindButton");
			if( obj != null && this.objectEnabled( obj ) )
				this.submitAndContinue( [{target: "-submitclose", n: "-browse", v: ""}] );
		}
	}
	
	this.goToFind = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			top.yuisupport.setOmitButtonSelected(false);
			var obj = sf.document.getElementById("findButton");
			if( obj != null && this.objectEnabled( obj ) )
				this.submitAndContinue( [{target: "-submitclose", n: "-find", v: ""}] );
		}
	}

	this.goToLayout = function( sel )
	{
		if( sel != null && sel.options != null )
		{
			var layID = sel.options[sel.selectedIndex].value;
			this.submitFindRequest( [{target: "-type", n: "-lay", v: layID},{target: "-submitclose", n: "-gotolayout", v: ""}] );
		}
	}
		
	this.goToNext = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("nextButton");
			if( obj != null && this.objectEnabled( obj ) )
				this.submitFindRequest( [{target: "-submitclose", n: "-next", v: ""}] );
		}
	}

	this.goToPrevious = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("prevButton");
			if( obj != null && this.objectEnabled( obj ) )
				this.submitFindRequest( [{target: "-submitclose", n: "-prev", v: ""}] );
		}
	}

	this.togglePieChart = function()
	{
		var disabled = this.objstate['pieLink'];
		if ((disabled != null) && !disabled)
		{	
			this.findOmitted();
			this.showPieChart();
		}
	}
	
	this.showPieChart = function( )
	{
		var pies = new Array("images/piechart/pie_chart_0.png",  "images/piechart/pie_chart_5.png",
							 "images/piechart/pie_chart_10.png", "images/piechart/pie_chart_15.png",
							 "images/piechart/pie_chart_20.png", "images/piechart/pie_chart_25.png",
							 "images/piechart/pie_chart_30.png", "images/piechart/pie_chart_35.png",
							 "images/piechart/pie_chart_40.png", "images/piechart/pie_chart_45.png",
							 "images/piechart/pie_chart_50.png", "images/piechart/pie_chart_55.png",
							 "images/piechart/pie_chart_60.png", "images/piechart/pie_chart_65.png",
							 "images/piechart/pie_chart_70.png", "images/piechart/pie_chart_75.png",
							 "images/piechart/pie_chart_80.png", "images/piechart/pie_chart_85.png",
							 "images/piechart/pie_chart_90.png", "images/piechart/pie_chart_95.png",
							 "images/piechart/pie_chart_100.png");

		var bFrame = this.bodyFrame;
		var info = bFrame.iwpinfo;
		var arraysize = 20;
		var slice = 0;
		var sf = this.statusFrame;
		if( sf != null )
		{
			if (info.total == info.found)
			{
				sf.document.pieButton.src = "images/piechart/pie_chart_none.png";
			}
			else
			{
				slice = Math.round(info.found / info.total * arraysize);
				if (slice == 0 && info.found != 0)
					slice = 1;
				else if (slice == arraysize && info.found != info.total)
					slice = arraysize-1;
				sf.document.pieButton.src = pies[slice];
			}
		}
	}
	
	this.resetRecordNumber = function( obj )
	{
		if (isStatusFrameValid() && obj != null)
		{
			obj.value = this.bodyFrame.iwpinfo.recnum;
		}
	}
	
	this.changeRecordNumber = function (val)
	{
		if (isStatusFrameValid() && val != null)
		{
			var obj = this.statusFrame.document.getElementById("recnumField");
			if (obj != null)
				obj.value = val;
		}
	}
	
	this.goToRecById = function( recordID )
	{
		var bf = this.bodyFrame;
		if( recordID != null && bf != null && bf.iwpinfo != null && ( ! bf.iwpinfo.confirm || ( bf.iwpinfo.mode == this.findMode || bf.iwpinfo.mode == this.browseMode ) ) )
			this.submitAndContinue( [{target: "-omitstate", n: "-recid", v: recordID},{target: "-submitclose", n: "-gotorecbyid", v: ""}] );
	}

	this.goToRecordByNum = function( recNum )
	{
		var bFrame = this.bodyFrame;
		var sFrame = this.statusFrame;
		if( bFrame != null && bFrame.iwpinfo != null && sFrame != null )
		{
			if( isNaN(recNum) || recNum < 1 )
			{
				return;
			}
			else if( bFrame.iwpinfo.found < recNum )
				recNum = bFrame.iwpinfo.found;
			this.submitAndContinue( [{target: "-omitstate", n: "-recordnumber", v: recNum},{target: "-submitclose", n: "-goto", v: ""}] );
		}
	}

	this.goToRecordNumber = function( objID )
	{
		var bFrame = this.bodyFrame;
		var sFrame = this.statusFrame;
		if( objID != null && bFrame != null && bFrame.iwpinfo != null && sFrame != null )
		{
			var obj = sFrame.document.getElementById(objID);
			if( obj != null )
			{
				var recNum = obj.value;
				if( isNaN(recNum) || recNum < 1 )
				{
					obj.value = bFrame.iwpinfo.recnum;
					return;
				}
				else if( bFrame.iwpinfo.found < recNum )
					recNum = bFrame.iwpinfo.found;
				this.submitAndContinue( [{target: "-omitstate", n: "-recordnumber", v: recNum},{target: "-submitclose", n: "-goto", v: ""}] );
			}
		}
	}

	this.goToRefind = function()
	{
		this.submitAndContinue( [{target: "-submitclose", n: "-refind", v: ""}] );
	}
	
    this.goToView = function(view){
        if (view != null) {
            var action = "-formview";
            if (view == "list") 
                action = "-listview";
            else 
                if (view == "table") 
                    action = "-tableview";
            this.submitFindRequest([{
                target: "-submitclose",
                n: action,
                v: ""
            }]);
        }
    }
	
	this.openHelpWindow = function( anchor )
	{
		if( anchor == null )
		{
			anchor = "Table_of_contents";
			var bFrame = this.bodyFrame;
			if( bFrame != null && bFrame.iwpinfo != null )
			{
				var info = bFrame.iwpinfo;
				if( info.mode == this.browseMode )
					anchor = "Navigating_records";
				else if( info.mode == this.editMode )
					anchor = "Editing_records";
				else if( info.mode == this.newMode )
					anchor = "Adding_data";
				else if( info.mode == this.findMode )
					anchor = "Finding_records";
			}
		}
		var win = window.open("/fmi/iwp/cgi?-gethelp&-anchor=" + anchor,"IWPHelp","top=20,left=20,height=460,width=620,fullscreen=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no");
	}
	
	this.openSortDlog = function()
	{
		var sf = this.statusFrame;
		if( sf != null )
		{
			var obj = sf.document.getElementById("sortButton");
			if( obj != null && this.objectEnabled( obj ) )
			{
				var url = this.cgiPath();
				if( url != null )
				{
					url += "-opensort";
					var win = window.open(url,"iwp_sort","alwaysraised=yes,dependent=yes,top=20,left=20,height=265,width=512,location=no,menubar=no,directories=no,resizable=no,scrollbars=no,status=no,toolbar=no,titlebar=no");
				
				//	set a reference to iwp in sort dialog so that when an error occurs it can be used to open the home page
					win.iwp = this;
				}
			}
		}
	}
				
	this.openInNewWindow = function( url )
	{
		if( url != null )
		{
			var winName = "iwp_" + this.winCounter++;
			var win = window.open(url,winName,"alwaysraised=yes,dependent=yes,top=20,left=20,height=265,width=512,location=no,menubar=no,directories=no,resizable=no,scrollbars=no,status=no,toolbar=no,titlebar=no");
		}
	}

	// gloabals
	this.isSafari10		=	this.checkForSafari10();
	this.browseMode		=	"browse";
	this.editMode		=	"edit";
	this.newMode		=	"new";
	this.findMode		=	"find";
	this.statusVisible	=	false;
	this.statusLocked = false;
	this.imgPath		=	"/fmi/iwp/res/images/";
	this.objstate		=	new Object();
	this.positions		=	new Object();
	this.debugurl		=	false;
	this.winCounter		=	0;
}

// Create Objects

if ( window.iwp == null )
	window.iwp = new IWPObj();
	
/*
	$Log: fmi_isp.js.h,v $

*/
